<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">
	
	
	
	<!-- Item 8 templates -->
	
<xsl:template name="Item8" >

<h3>A. Identifying Owners, Officers and Other <em>Control Persons</em></h3>
<p>(1) In this Item, identify every <em>person</em>  that, directly or indirectly, 
     <em>controls </em> the applicant, or that the applicant directly or indirectly <em>controls</em>.</p>
<blockquote>
  <p>(a) If this is an initial application, the applicant must complete Schedule A and Schedule B. </p>
  <p style="padding-left:25px;">Schedule A asks for information about direct owners and executive officers. </p>
  <p style="padding-left:25px;">Schedule B asks for information about indirect owners. </p>
  <p>(b) If this is an amendment updating information reported on either the Schedule A or Schedule B 
  (or both) filed with the applicant's initial application, the applicant must also complete Schedule C. </p>
  </blockquote>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(2) Does any <em>person</em> not named in Item 1-A or Schedules A, B, or C, 
                       directly or indirectly, <em>control</em> the applicant's management or policies?</div>
    <div class="tdStyle1 tditem10col2">
		<xsl:choose>
			<xsl:when test="string(m1:controls/m1:isCPForApplicantPolicy) = 'Y'">
				<img src="Images/radio-checked.jpg"  alt="radio button checked" /> Yes 
				<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No 
			</xsl:when>
			
			<xsl:when test="string(m1:controls/m1:isCPForApplicantPolicy) = 'N'">
				<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
				<img src="Images/radio-checked.jpg" alt="radio button checked"  /> No 
			</xsl:when>
			
			<xsl:otherwise>
				<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
				<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No 
			</xsl:otherwise>
		</xsl:choose>
    </div>
  </div>
  <div style="clear:both"></div>
</div>
<p>(3) If &quot;Yes&quot; to Item 8-A.2. above, complete <b><u>Section 8-A of Schedule D</u></b>.</p>
<h3>B. Public Reporting Companies</h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(1) Is any <em>person</em> in Schedules A, B, or C, or in Section 8-A of Schedule D a 
             public reporting company under Sections 12 or 15(d) of the Securities Exchange Act of 1934?</div>
     <div class="tdStyle1 tditem10col2">
		<xsl:choose>
			<xsl:when test="string(m1:controls/m1:isPRCompanyUnder1215) = 'Y'">
				<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes 
				<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No 
			</xsl:when>
			
			<xsl:when test="string(m1:controls/m1:isPRCompanyUnder1215) = 'N'">
				<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
				<img src="Images/radio-checked.jpg" alt="radio button checked" /> No 
			</xsl:when>
			
			<xsl:otherwise>
				<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
				<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No 
			</xsl:otherwise>
		</xsl:choose>						
   </div>
  </div>
  <div style="clear:both"></div>
</div>
<p>(2) If &quot;Yes&quot; to Item 8-B.1. above, complete <b><u>Section 8-B of Schedule D</u></b>.</p>
</xsl:template>

</xsl:stylesheet>